package com.link.hub.service.weChatMiniProgram.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryActivityDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryActivityMapper;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWq;
import com.link.hub.pojo.mp.dto.LotteryActivityRelDto;
import com.link.hub.pojo.mp.vo.LotteryParticipateVo;
import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.pojo.mp.vo.MyLotteryVo;
import com.link.hub.service.weChatMiniProgram.LotteryActivityService;
import com.link.hub.service.weChatMiniProgram.LotteryParticipateService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 抽奖活动业务服务实现类
 */
@Service
public class LotteryActivityServiceImpl extends ServiceImpl<LotteryActivityMapper, LotteryActivity>
        implements LotteryActivityService {
    @Resource
    private LotteryActivityDao lotteryActivityDao;
    @Resource
    private LotteryParticipateService lotteryParticipateService;


    @Override
    public LotteryActivity getActivityById(Long id) {
        // 默认继承 BaseServiceImpl 的 getById 已处理逻辑删除
        return super.getById(id);
    }

    @Override
    public List<LotteryVo> queryList() {
        // 默认继承 BaseServiceImpl 的 list 已处理逻辑删除
        LotteryWq wq = new LotteryWq();
        wq.setStatus("1");
        List<LotteryActivity> lotterys =lotteryActivityDao.queryList(wq);
        // 转换为 Vo 列表
        List<LotteryVo> lotteryVos = BeanUtils.transitionDtos(lotterys, LotteryVo.class);
        return lotteryVos;
    }

    @Override
    public List<MyLotteryVo> queryMyRecord() {
        Long userId = SecurityUtils.getUserId();

        // 查询关联的活动
        List<LotteryParticipateVo> userParticipateList = lotteryParticipateService.getUserParticipateList(userId);
        List<Long> activityIds = userParticipateList.stream()
                .map(LotteryParticipateVo::getActivityId)
                .collect(Collectors.toList());
        if(ObjectUtil.isNotEmpty(activityIds)){
            LotteryWq wq = new LotteryWq();
            wq.setStatus("1");
            wq.setActivityIds(activityIds);
            // 查询出 我参与的抽奖活动
            List<LotteryActivityRelDto> myLotterys =lotteryActivityDao.queryMyRecord(wq);
            // 转换为 Vo 列表
            List<MyLotteryVo> lotteryVos = BeanUtils.transitionDtos(myLotterys, MyLotteryVo.class);

            return lotteryVos;
        }
        return Collections.emptyList();


    }

    // 可添加其他业务方法，如：
    // - 检查活动有效性（时间范围 + 状态）
    // - 查询未开始/进行中活动列表
}
