package com.link.hub.domain.weChatMiniProgram.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryActivityDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryActivityMapper;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWq;
import com.link.hub.pojo.mp.dto.LotteryActivityRelDto;
import com.sfa.common.core.utils.bean.BeanUtils;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 抽奖活动数据访问实现类
 */
@Repository
public class LotteryActivityDaoImpl implements LotteryActivityDao {

    @Resource
    private LotteryActivityMapper lotteryActivityMapper;

    @Override
    public LotteryActivity getActivityById(Long id) {
        // 调用 MyBatis Mapper 方法
        return lotteryActivityMapper.selectById(id);
    }

    @Override
    public List<LotteryActivity> getOngoingActivities() {
        // 自定义查询条件示例（需在 Mapper 中定义方法）
        return lotteryActivityMapper.selectList(
                new QueryWrapper<LotteryActivity>()
                        .lambda()
                        .eq(LotteryActivity::getStatus, 1)  // 状态为进行中
                        .ge(LotteryActivity::getStartTime, LocalDateTime.now())  // 开始时间 <= 当前时间
                        .le(LotteryActivity::getEndTime, LocalDateTime.now())    // 结束时间 >= 当前时间
                        .eq(LotteryActivity::getDeleteFlag, 0)  // 未删除
        );
    }

    @Override
    public List<LotteryActivity> queryList(LotteryWq wq) {
        // 调用 MyBatis Mapper 方法
        List<LotteryActivity> lotteryActivities = lotteryActivityMapper.selectList(
                new QueryWrapper<LotteryActivity>()
                        .lambda()
                        .eq(ObjectUtil.isNotEmpty(wq.getStatus()), LotteryActivity::getStatus, wq.getStatus())
                        // 开始时间 <= 当前时间
//                        .ge(LotteryActivity::getStartTime, LocalDateTime.now())
                        // 结束时间 >= 当前时间
//                        .le(LotteryActivity::getEndTime, LocalDateTime.now())
                        .eq(LotteryActivity::getDeleteFlag, 0)
                        .orderByDesc(LotteryActivity::getCreateTime)
        );
        return lotteryActivities;
    }

    /**
     * 查询我的参与活动列表
     *
     * @param wq
     * @return
     */
    @Override
    public List<LotteryActivityRelDto> queryMyRecord(LotteryWq wq) {
        // 查询我的参与活动记录
        Wrapper<LotteryActivity> wrapper = getWrapper(wq);
        List<LotteryActivity> lotteryActivities = lotteryActivityMapper.selectList(wrapper);

        List<LotteryActivityRelDto> lotteryActivityRelDtos = lotteryActivities.stream().map(lotteryActivity -> {
            LotteryActivityRelDto lotteryActivityRelDto =  BeanUtils.transitionDto(lotteryActivity, LotteryActivityRelDto.class);
            lotteryActivityRelDto.setId(lotteryActivity.getId());
            lotteryActivityRelDto.setActivityId(lotteryActivity.getId());
            return lotteryActivityRelDto;
        }).collect(Collectors.toList());

        return lotteryActivityRelDtos;
    }

    private Wrapper<LotteryActivity> getWrapper(LotteryWq wq) {
        LambdaQueryWrapper<LotteryActivity> lotteryActivityLambdaQueryWrapper = new LambdaQueryWrapper<>();
        lotteryActivityLambdaQueryWrapper
                .eq(ObjectUtil.isNotEmpty(wq.getStatus()), LotteryActivity::getStatus, wq.getStatus())
                .eq(ObjectUtil.isNotEmpty(wq.getActivityId()), LotteryActivity::getId, wq.getActivityId())
                .in(ObjectUtil.isNotEmpty(wq.getActivityIds()), LotteryActivity::getId, wq.getActivityId())
                .eq(ObjectUtil.isNotEmpty(wq.getUserId()), LotteryActivity::getCreateBy, wq.getUserId())
                .eq(ObjectUtil.isNotEmpty(wq.getStatus()), LotteryActivity::getStatus, wq.getStatus())
                .eq(LotteryActivity::getDeleteFlag, ObjectUtil.defaultIfNull(wq.getDeleteFlag(), 0))
                .orderByDesc(LotteryActivity::getCreateTime);
        return lotteryActivityLambdaQueryWrapper;
    }
}
