package com.link.hub.controller.mp.query;

import com.link.hub.pojo.mp.vo.MiniProgramOpenIdVO;
import com.link.hub.pojo.mp.vo.MpLoginVo;
import com.link.hub.service.officeAccount.WechatOfficeAccountService;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author : liqiulin
 * @date : 2025-03-07 13
 * @describe :
 */
@RestController
@RequestMapping("/miniProgram")
public class WechatMiniProgramController {

    @Resource
    private WechatMiniProgramService wechatMiniProgramService;
    @Resource
    private WechatOfficeAccountService wechatOfficeAccountService;
    @PostMapping("/login")
    public MiniProgramOpenIdVO mpLogin(@RequestBody MpLoginVo vo) {
        MiniProgramOpenIdVO userInfo = wechatMiniProgramService.getUserInfo(vo);
        return userInfo;
    }

    /**
     * 是否关注公众号
     * @param openid
     */
    @GetMapping("/query/isSubscribe")
    public Boolean isSubscribe(String openid) {
        return wechatOfficeAccountService.isSubscribe(openid);
    }


}
