package com.link.hub.service.weChatMiniProgram.impl;

import cn.hutool.core.date.DateUtil;
import com.link.hub.domain.weChatMiniProgram.dao.WechatMiniProgramUserDao;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.domain.weChatMiniProgram.wq.WechatMiniProgramUserWq;
import com.link.hub.pojo.weChatMiniProgram.dto.MiniProgramOpenIdDTO;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 小程序用户服务实现
 */
@Service
public class WechatMiniProgramUserServiceServiceImpl implements WechatMiniProgramUserService {

    @Resource
    private WechatMiniProgramUserDao wechatMiniProgramUserDao;

    @Override
    public WechatMiniProgramUser queryMiniProgramUserByOpenId(String openid) {
        WechatMiniProgramUserWq wechatMiniProgramUserWq = new WechatMiniProgramUserWq();
        wechatMiniProgramUserWq.setOpenid(openid);
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserDao.queryMiniProgramUserWq(wechatMiniProgramUserWq);
        return wechatMiniProgramUser;
    }

    @Override
    public Long saveMiniProgramUser(MiniProgramOpenIdDTO miniProgramOpenIdDTO) {
        WechatMiniProgramUser wechatMiniProgramUser = new WechatMiniProgramUser();
        wechatMiniProgramUser.setOpenid(miniProgramOpenIdDTO.getOpenid());
        wechatMiniProgramUser.setCreateTime(DateUtil.date());
        wechatMiniProgramUser.setUpdateTime(DateUtil.date());
        wechatMiniProgramUserDao.insert(wechatMiniProgramUser);

        return wechatMiniProgramUser.getId();
    }
}
