package com.link.hub.service.weChatMiniProgram.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSONObject;
import com.link.hub.config.WeChatMiniProgramConfig;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.pojo.weChatMiniProgram.dto.MiniProgramOpenIdDTO;
import com.link.hub.pojo.weChatMiniProgram.vo.MiniProgramOpenIdVO;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramService;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.core.utils.JwtUtils;
import com.sfa.common.core.utils.ip.IpUtils;
import com.sfa.common.core.utils.uuid.IdUtils;
import com.sfa.common.core.utils.wechat.WeChatPlatFormUtils;
import com.sfa.common.security.service.TokenService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;


/**
 * 小程序服务实现
 */
@Service
public class WechatMiniProgramServiceServiceImpl implements WechatMiniProgramService {
    @Resource
    private WeChatMiniProgramConfig weChatMiniProgramConfig;
    @Resource
    private WechatMiniProgramUserService miniProgramUserService;
    @Resource
    private TokenService tokenService;
    @Value("${mini.program.jwt.expire:720}")
    private Long expireTime;

    @Override
    public MiniProgramOpenIdVO getUserInfo(String code) {
        JSONObject jsonObject = WeChatPlatFormUtils.getOpenid(code, weChatMiniProgramConfig.getAppId(), weChatMiniProgramConfig.getAppSecret());
        // 从jsonObject中获取openid
        String openid = jsonObject.getString("openid");
        String unionid = jsonObject.getString("unionid");
        if (ObjectUtil.isEmpty(openid)) {
            throw new ServiceException("获取openid失败");
        }
        WechatMiniProgramUser wechatMiniProgramUser = miniProgramUserService.queryMiniProgramUserByOpenId(openid);
        Long userId = null;

        if (ObjectUtil.isNotEmpty(wechatMiniProgramUser)) {
            // 查询到数据不再新增
            userId = wechatMiniProgramUser.getId();
        } else {
            // 保存小程序用户信息 新增小程序用户信息
            MiniProgramOpenIdDTO miniProgramOpenIdDTO = new MiniProgramOpenIdDTO();
            miniProgramOpenIdDTO.setOpenid(openid);
            miniProgramOpenIdDTO.setUnionid(unionid);
            userId = miniProgramUserService.saveMiniProgramUser(miniProgramOpenIdDTO);
        }
        LoginUser loginUser = new LoginUser();
        String token = IdUtils.fastUUID();

        String userName = "openid";
        loginUser.setToken(token);
        loginUser.setUserid(userId);
        loginUser.setUsername(userName);
        loginUser.setIpaddr(IpUtils.getIpAddr());
        tokenService.saveMiniProgramToken(loginUser, expireTime);


        // 返回token
        Map<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put(SecurityConstants.USER_KEY, token);
        claimsMap.put(SecurityConstants.DETAILS_USER_ID, userId);
        claimsMap.put(SecurityConstants.DETAILS_USERNAME, userName);
        String jwtToken = JwtUtils.createToken(claimsMap);

        // 返回结果
        MiniProgramOpenIdVO miniProgramOpenIdVO = new MiniProgramOpenIdVO();
        miniProgramOpenIdVO.setOpenid(openid);
        miniProgramOpenIdVO.setUnionid(unionid);
        // 查询是否关注了微信公众号
//        miniProgramOpenIdVO.setSubscribeFlag(true);
//        miniProgramOpenIdVO.setSubscribeTime(DateUtil.date());
        miniProgramOpenIdVO.setToken(jwtToken);
        miniProgramOpenIdVO.setUserId(userId);

        return miniProgramOpenIdVO;
    }

    @Override
    public Object isSubscribe(String openid) {


        /**
         * 通过发送模板消息判断用户是否关注公众号
         * @param openId
         * @param templateId
         * @param accessToken
         * @return true表示已关注，false表示未关注
         */
        //                用户的OpenID
        String openId = "用户OpenID";
//                一个不存在的模板ID

        String templateId = "一个不存在的模板ID";
        // 公众号的access_token
        JSONObject bodyJson = WeChatPlatFormUtils.getMiniappToken(weChatMiniProgramConfig.getAppId(), weChatMiniProgramConfig.getAppSecret());

        String accessToken = bodyJson.getString("access_token");
        return WeChatPlatFormUtils.isSubscribe(openId, templateId, accessToken);
    }
}
