package com.link.hub.service.weChatMiniProgram.impl;

import com.link.hub.domain.weChatMiniProgram.dao.WechatMiniProgramUserDao;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.domain.weChatMiniProgram.wq.WechatMiniProgramUserWq;
import com.link.hub.pojo.mp.bo.MpUserBo;
import com.link.hub.pojo.mp.dto.MpOpenIdDTO;
import com.link.hub.pojo.mp.dto.WeChatMpUserDto;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import com.sfa.common.security.utils.SecurityUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 小程序用户服务实现
 */
@Slf4j
@Service
public class WechatMiniProgramUserServiceServiceImpl implements WechatMiniProgramUserService {

    @Resource
    private WechatMiniProgramUserDao wechatMiniProgramUserDao;

    /**
     * 查询小程序用户
     *
     * @param mpUserDto
     * @return
     */
    @Override
    public WechatMiniProgramUser queryMiniProgramUserOne(WeChatMpUserDto mpUserDto) {
        WechatMiniProgramUserWq wechatMiniProgramUserWq = new WechatMiniProgramUserWq();
        wechatMiniProgramUserWq.setOpenid(mpUserDto.getOpenid());
        wechatMiniProgramUserWq.setUserId(mpUserDto.getId());
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserDao.queryMiniProgramUserOne(wechatMiniProgramUserWq);

        return wechatMiniProgramUser;
    }

    @Override
    public Long saveMiniProgramUser(MpOpenIdDTO mpOpenIdDTO) {
        WechatMiniProgramUser wechatMiniProgramUser = WechatMiniProgramUser.create(mpOpenIdDTO);
        wechatMiniProgramUserDao.insert(wechatMiniProgramUser);
        return wechatMiniProgramUser.getId();
    }

    @Override
    public Long updateMiniProgramUser(MpOpenIdDTO mpOpenIdDTO) {
        WechatMiniProgramUser wechatMiniProgramUser = WechatMiniProgramUser.create(mpOpenIdDTO);
        wechatMiniProgramUser.setId(mpOpenIdDTO.getId());
        wechatMiniProgramUserDao.updateById(wechatMiniProgramUser);
        return wechatMiniProgramUser.getId();
    }

    @Override
    public WechatMiniProgramUser updateUserInfo(MpUserBo mpUserBo) {
        // 根据用户id查询
        Long userId = SecurityUtils.getUserId();
        WechatMiniProgramUserWq wq = new WechatMiniProgramUserWq();
        wq.setUserId(userId);
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserDao.queryMiniProgramUserOne(wq);

        // 修改用户信息
        wechatMiniProgramUser.setNickname(mpUserBo.getNickname());
        wechatMiniProgramUser.setAvatarUrl(mpUserBo.getAvatarUrl());
        wechatMiniProgramUserDao.updateById(wechatMiniProgramUser);

        return wechatMiniProgramUser;
    }
}
