package com.link.hub.service.weChatMiniProgram.impl;

import com.link.hub.domain.weChatMiniProgram.dao.LotteryWinningDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinning;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import com.link.hub.pojo.mp.dto.LotteryWinningDto;
import com.link.hub.service.weChatMiniProgram.LotteryWinningService;
import com.sfa.common.core.exception.ServiceException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户中奖记录服务层实现类
 */
@Service
public class LotteryWinningServiceImpl implements LotteryWinningService {

    @Resource
    private LotteryWinningDao lotteryWinningDao;

    @Override
    public List<LotteryWinning> queryList(LotteryWinningWq wq) {
        return lotteryWinningDao.queryList(wq);
    }

    @Override
    public LotteryWinningDto getDetail(Long id) {
        LotteryWinning lotteryWinning = lotteryWinningDao.selectById(id);
        if (lotteryWinning == null) {
            throw new ServiceException("中奖记录不存在");
        }
        return LotteryWinningDto.convert(lotteryWinning);
    }

    @Override
    public LotteryWinning save(LotteryWinningDto lotteryWinningDto) {
        LotteryWinning lotteryWinning = LotteryWinning.convert(lotteryWinningDto);
        int result = lotteryWinningDao.insert(lotteryWinning);
        if (result <= 0) {
            throw new ServiceException("保存中奖记录失败");
        }
        return lotteryWinning;
    }

    @Override
    public LotteryWinning update(LotteryWinningDto lotteryWinningDto) {
        LotteryWinning existing = lotteryWinningDao.selectById(lotteryWinningDto.getId());
        if (existing == null) {
            throw new ServiceException("中奖记录不存在");
        }

        LotteryWinning lotteryWinning = LotteryWinning.convert(lotteryWinningDto);
        int result = lotteryWinningDao.updateById(lotteryWinning);
        if (result <= 0) {
            throw new ServiceException("更新中奖记录失败");
        }
        return lotteryWinning;
    }

    @Override
    public boolean delete(Long id) {
        LotteryWinning existing = lotteryWinningDao.selectById(id);
        if (existing == null) {
            throw new ServiceException("中奖记录不存在");
        }

        existing.setDeleteFlag(1);
        return lotteryWinningDao.updateById(existing) > 0;
    }

    @Override
    public List<LotteryWinningDto> getUserWinningRecords(Long activityId, Long userId) {
        List<LotteryWinning> winnings = lotteryWinningDao.queryUserWinningRecords(activityId, userId);
        return winnings.stream()
                       .map(LotteryWinningDto::convert)
                       .collect(Collectors.toList());
    }

    @Override
    public long countWinningByActivity(Long activityId) {
        return lotteryWinningDao.countWinningByActivity(activityId);
    }

    @Override
    public List<LotteryWinningDto> getUnreceivedPrizes(Long userId) {
        List<LotteryWinning> winnings = lotteryWinningDao.queryUnreceivedPrizes(userId);
        return winnings.stream()
                       .map(LotteryWinningDto::convert)
                       .collect(Collectors.toList());
    }

    @Override
    public boolean claimPrize(Long winningId) {
        LotteryWinning winning = lotteryWinningDao.selectById(winningId);
        if (winning == null) {
            throw new ServiceException("中奖记录不存在");
        }

        // 检查是否已领取或已作废
        if (winning.getIsReceive() != 0) {
            throw new ServiceException("奖品状态不正确，无法领取");
        }

        // 更新为已领取状态
        winning.setIsReceive(1);
        winning.setReceiveTime(LocalDateTime.now());
        return lotteryWinningDao.updateById(winning) > 0;
    }

    @Override
    public boolean hasWinning(Long activityId, Long userId) {
        return lotteryWinningDao.hasWinning(activityId, userId);
    }

    @Override
    public LotteryWinning selectWinningDetail(Long activityId, Long userId) {
        return lotteryWinningDao.getWinningDetail(activityId, userId);
    }
}
