package com.link.hub.service.weChatMiniProgram.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryWinningAddressDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinningAddress;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryWinningAddressMapper;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningAddressWq;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import com.link.hub.service.weChatMiniProgram.LotteryWinningAddressService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 中奖记录-物流地址关联表Service实现类
 */
@Service
public class LotteryWinningAddressServiceImpl extends ServiceImpl<LotteryWinningAddressMapper, LotteryWinningAddress> implements LotteryWinningAddressService {

    private final LotteryWinningAddressDao lotteryWinningAddressDao;

    public LotteryWinningAddressServiceImpl(LotteryWinningAddressDao lotteryWinningAddressDao) {
        this.lotteryWinningAddressDao = lotteryWinningAddressDao;
    }

    @Override
    public List<LotteryWinningAddress> queryList(LotteryWinningWq wq) {
        return lotteryWinningAddressDao.queryList(wq);
    }

    @Override
    public IPage<LotteryWinningAddress> queryPage(Page<LotteryWinningAddress> page, Wrapper<LotteryWinningAddress> wrapper) {
        return lotteryWinningAddressDao.queryPage(page, wrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveOrUpdateAddress(LotteryWinningAddress address) {
        if (address.getId() == null) {
            return lotteryWinningAddressDao.saveAddress(address);
        } else {
            return lotteryWinningAddressDao.updateAddress(address);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deleteAddress(Long id) {
        return lotteryWinningAddressDao.deleteAddress(id);
    }

    @Override
    public LotteryWinningAddress getByWinningId(Long winningId) {
        return lotteryWinningAddressDao.getByWinningId(winningId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean setDefaultAddress(Long userId, Long addressId) {
        // 设置指定地址为默认地址
        LotteryWinningAddress address = new LotteryWinningAddress();
        address.setId(addressId);
        address.setIsDefault(1);
        return lotteryWinningAddressDao.updateAddress(address);
    }

    @Override
    public LotteryWinningAddress getDefaultAddress(Long userId) {
        return lotteryWinningAddressDao.getDefaultAddress(userId);
    }

    @Override
    public LotteryWinningAddress selectAddressOne(Long activityId, Long userId) {
        LotteryWinningAddressWq wq = new LotteryWinningAddressWq();
        wq.setActivityId(activityId);
        wq.setUserId(userId);
        LotteryWinningAddress address = lotteryWinningAddressDao.selectOne(wq);
        return address;
    }


}
