package com.link.hub.service.weChatMiniProgram.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryParticipateDao;
import com.link.hub.domain.weChatMiniProgram.entity.*;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryParticipateMapper;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryParticipateWq;
import com.link.hub.pojo.mp.bo.LotteryParticipateBo;
import com.link.hub.pojo.mp.bo.LotteryWinningAddresssBo;
import com.link.hub.pojo.mp.dto.LotteryDto;
import com.link.hub.pojo.mp.dto.LotteryParticipateDto;
import com.link.hub.pojo.mp.dto.WeChatMpUserDto;
import com.link.hub.pojo.mp.vo.LotteryParticipateVo;
import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.pojo.mp.vo.MyLotteryVo;
import com.link.hub.service.officeAccount.WechatOfficeAccountService;
import com.link.hub.service.weChatMiniProgram.*;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户参与抽奖记录Service实现类
 */
@Service
public class LotteryParticipateServiceImpl extends ServiceImpl<LotteryParticipateMapper, LotteryParticipate>
        implements LotteryParticipateService {

    @Resource
    private LotteryParticipateDao lotteryParticipateDao;
    @Resource
    private LotteryWinningService lotteryWinningService;
    @Resource
    private LotteryActivityService activityService;
    @Resource
    private LotteryWinningAddressService addressService;
    @Resource
    private WechatMiniProgramUserService wechatMiniProgramUserService;

    @Resource
    private WechatOfficeAccountService wechatOfficeAccountService;

    @Override
    public LotteryParticipate participateLottery(LotteryParticipateBo participateBo) {

        // 1.检验是否关注公众号
        WeChatMpUserDto mpUserDto = new WeChatMpUserDto();
        mpUserDto.setId(SecurityUtils.getUserId());
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserService.queryMiniProgramUserOne(mpUserDto);
        // 根据用户id查询小程序的用户信息
        if (wechatMiniProgramUser == null) {
            throw new ServiceException("用户不存在");
        }
        String openid = wechatMiniProgramUser.getOpenid();
        if (!wechatOfficeAccountService.checkIsSubscribe(openid)) {
            throw new IllegalArgumentException("用户未关注公众号");
        }

        // 2. 校验是否已参与抽奖（防重）
        Long activityId = participateBo.getActivityId();
        Long userId = SecurityUtils.getUserId();
        if (lotteryParticipateDao.hasParticipated(activityId, userId)) {
            throw new IllegalArgumentException("用户已参与抽奖");
        }
        // 查询活动信息
        LotteryActivity lotteryActivity = activityService.getById(activityId);
        if (lotteryActivity == null) {
            throw new ServiceException("抽奖活动不存在");
        }
        if (lotteryActivity.getStatus() != 1) {
            throw new IllegalArgumentException("抽奖活动已结束");
        }
        participateBo.setLotteryTime(lotteryActivity.getLotteryTime());
        participateBo.setTitle(lotteryActivity.getTitle());

        // 2. 创建参与记录
        LotteryParticipateDto dto = LotteryParticipateDto.convert(participateBo);
        // 3. 保存记录（插入数据库）
        LotteryParticipate lotteryParticipate = lotteryParticipateDao.saveParticipate(dto);
        return lotteryParticipate;
    }

    @Override
    public boolean checkUserParticipated(Long activityId, Long userId) {
        return lotteryParticipateDao.checkUserParticipated(activityId, userId);
    }

    @Override
    public List<LotteryParticipateVo> getUserParticipateList(Long userId) {
        // 实现查询逻辑，获取用户参与记录 需要根据实际情况添加查询条件
        LotteryParticipateWq wq = new LotteryParticipateWq();
        wq.setUserId(userId);
        wq.setDeleteFlag(0);
        List<LotteryParticipate> participates = lotteryParticipateDao.queryList(wq);

        List<LotteryParticipateVo> vos = participates.stream()
                .map(participate -> {
                    LotteryParticipateVo vo = LotteryParticipateVo.convert(participate);
                    return vo;
                }).collect(Collectors.toList());
        return vos;
    }

    @Override
    public int getUserParticipateCount(Long userId) {
        return lotteryParticipateDao.getUserParticipateCount(userId);
    }

    @Override
    public List<MyLotteryVo> queryMyRecord() {
        Long userId = SecurityUtils.getUserId();
        // 查询中奖信息
        LotteryParticipateWq wq = new LotteryParticipateWq();
        wq.setUserId(userId);
        List<LotteryParticipate> participates = lotteryParticipateDao.queryList(wq);

        List<MyLotteryVo> vos = participates.stream()
                .map(participate -> {
                    MyLotteryVo vo = MyLotteryVo.convert4LotteryParticipate(participate);
                    // 中奖的话，物流单号查询
                    if (participate.getLotteryStatus() > 3) {
                        LotteryWinningAddress address = addressService.selectAddressOne(participate.getActivityId(), userId);
                        vo.setLogisticsNumber(address.getLogisticsNumber());
                    }
                    // 中奖的话，查询奖品
                    if (participate.getLotteryStatus() > 3) {
                        LotteryWinning lotteryWinning = lotteryWinningService.selectWinningDetail(participate.getActivityId(), userId);
                        vo.setLotteryPrizeName(lotteryWinning.getPrizeName());
                        vo.setLotteryPrizeImg(lotteryWinning.getPrizeImg());
                        vo.setWinningLevel(lotteryWinning.getWinningLevel());
                    }
                    return vo;
                }).collect(Collectors.toList());
        return vos;
    }

    /**
     * 查询我的抽奖信息
     *
     * @return
     */
    @Override
    public LotteryVo queryLotteryInfo(Long activityId) {

        // 查询中奖信息
        Long userId = SecurityUtils.getUserId();
        LotteryDto dto = new LotteryDto();
        dto.setActivityId(activityId);
        dto.setUserId(userId);

        LotteryDto myLotteryDto = lotteryParticipateDao.queryLotteryInfo(dto);
        LotteryVo myLotteryVo = null;
        if (myLotteryDto != null) {
            // 查询活动信息
            // 查询奖品信息
            return myLotteryVo;
        } else {
            myLotteryVo = LotteryVo.convertNoParticipate();
            return myLotteryVo;
        }
    }

    @Override
    public List<LotteryVo> queryList() {
        return null;
    }

    /**
     * 用户参与抽奖地址
     *
     * @param lotteryParticipateBo
     * @return
     */
    @Override
    public LotteryWinningAddress participateLotteryAddress(LotteryWinningAddresssBo lotteryParticipateBo) {
        Long userId = SecurityUtils.getUserId();
        // 1、校验用户是否参与抽奖
        if (!lotteryParticipateDao.hasParticipated(lotteryParticipateBo.getActivityId(), userId)) {
            // 用户未参与抽奖
            throw new IllegalArgumentException("用户未参与抽奖");
        }

        // 2、校验用户是否已中奖
        if (!lotteryWinningService.hasWinning(lotteryParticipateBo.getActivityId(), userId)) {
            // 用户未中奖
            throw new IllegalArgumentException("用户未中奖");
        }

        // 查询中奖信息
        LotteryWinning lotteryWinning = lotteryWinningService.selectWinningDetail(lotteryParticipateBo.getActivityId(), userId);
        if (lotteryWinning.getLogisticsNumber() != null) {
            // 用户未中奖
            throw new IllegalArgumentException("已发货,请联系客服");
        }
        LotteryWinningAddress lotteryWinningAddress = addressService.selectAddressOne(lotteryParticipateBo.getActivityId(), userId);
        // 1. 校验是否已填写地址 填写 修改地址 未填写 新增地址
        if (lotteryWinningAddress != null && lotteryWinningAddress.getId() != null) {
            // 修改地址
            lotteryParticipateBo.setId(lotteryWinningAddress.getId());
        }
        lotteryWinningAddress = LotteryWinningAddress.create(lotteryParticipateBo);
        lotteryWinningAddress.setWinningId(lotteryWinning.getId());
        lotteryWinningAddress.setUserId(userId);
        addressService.saveOrUpdateAddress(lotteryWinningAddress);
        return lotteryWinningAddress;
    }

    @Override
    public List<LotteryVo> announcementList() {
        // 获取抽奖列表
        List<LotteryVo> lotteryVos = lotteryParticipateDao.announcementList();

        return null;
    }
}
