package com.link.hub.service.weChatMiniProgram.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryActivityMapper;
import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.service.weChatMiniProgram.LotteryActivityService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抽奖活动服务实现类
 */
@Service
public class LotteryActivityServiceImpl extends ServiceImpl<LotteryActivityMapper, LotteryActivity> implements LotteryActivityService {

    @Resource
    private com.link.hub.domain.weChatMiniProgram.dao.LotteryActivityDao lotteryActivityDao;

    @Override
    public IPage<LotteryActivity> queryActiveActivities(Integer status, Integer pageNum, Integer pageSize) {
        Page<LotteryActivity> page = new Page<>(pageNum, pageSize);
        LambdaQueryWrapper<LotteryActivity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryActivity::getDeleteFlag, 0)
                .eq(status != null, LotteryActivity::getStatus, status)
//                .ge(LotteryActivity::getStartTime, new Date())
//                .le(LotteryActivity::getEndTime, new Date())
                .orderByDesc(LotteryActivity::getStartTime);
        return lotteryActivityDao.selectPage(page, wrapper);
    }

    @Override
    public LotteryActivity getDetailById(Long activityId) {
        return lotteryActivityDao.selectById(activityId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createActivity(LotteryActivity activity) {
        activity.setDeleteFlag(0);
        return save(activity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateActivity(LotteryActivity activity) {
        return updateById(activity);
    }

    @Override
    public List<LotteryVo> queryList() {
        return null;
    }



    /**
     * 查询活动列表
     * @return
     */
    @Override
    public List<LotteryActivity> queryActiveActivityList() {
        // 小程序端查询列表
        List<LotteryActivity> list = lotteryActivityDao.queryActiveActivityList();
        return list;
    }


}
