package com.link.hub.service.weChatMiniProgram;

import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinning;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import com.link.hub.pojo.mp.dto.LotteryWinningDto;
import java.util.List;

/**
 * 用户中奖记录服务层接口
 */
public interface LotteryWinningService {

    /**
     * 查询中奖记录列表
     */
    List<LotteryWinning> queryList(LotteryWinningWq wq);

    /**
     * 根据ID获取中奖记录详情
     */
    LotteryWinningDto getDetail(Long id);

    /**
     * 新增中奖记录
     */
    LotteryWinning save(LotteryWinningDto lotteryWinningDto);

    /**
     * 更新中奖记录
     */
    LotteryWinning update(LotteryWinningDto lotteryWinningDto);

    /**
     * 删除中奖记录（逻辑删除）
     */
    boolean delete(Long id);

    /**
     * 查询用户中奖记录
     */
    List<LotteryWinningDto> getUserWinningRecords(Long activityId, Long userId);

    /**
     * 统计活动中奖人数
     */
    long countWinningByActivity(Long activityId);

    /**
     * 查询用户未领取奖品
     */
    List<LotteryWinningDto> getUnreceivedPrizes(Long userId);

    /**
     * 领取奖品
     */
    boolean claimPrize(Long winningId);

    boolean hasWinning(Long activityId, Long userId);

    LotteryWinning selectWinningDetail(Long activityId, Long userId);
}
