package com.link.hub.service.weChatMiniProgram;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinningAddress;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import java.util.List;

/**
 * 中奖记录-物流地址关联表Service接口
 */
public interface LotteryWinningAddressService extends IService<LotteryWinningAddress> {

    /**
     * 根据条件查询地址列表
     * @param wq 查询条件
     * @return 地址列表
     */
    List<LotteryWinningAddress> queryList(LotteryWinningWq wq);

    /**
     * 分页查询地址信息
     * @param page 分页参数
     * @param wrapper 查询条件
     * @return 地址分页结果
     */
    IPage<LotteryWinningAddress> queryPage(Page<LotteryWinningAddress> page, Wrapper<LotteryWinningAddress> wrapper);

    /**
     * 保存或更新地址信息
     * @param address 地址信息
     * @return 是否成功
     */
    boolean saveOrUpdateAddress(LotteryWinningAddress address);

    /**
     * 删除地址信息（逻辑删除）
     * @param id 地址ID
     * @return 是否成功
     */
    boolean deleteAddress(Long id);

    /**
     * 根据中奖记录ID获取地址信息
     * @param winningId 中奖记录ID
     * @return 地址信息
     */
    LotteryWinningAddress getByWinningId(Long winningId);

    /**
     * 设置默认地址
     * @param userId 用户ID
     * @param addressId 地址ID
     * @return 是否成功
     */
    boolean setDefaultAddress(Long userId, Long addressId);

    /**
     * 获取用户的默认地址
     * @param userId 用户ID
     * @return 默认地址
     */
    LotteryWinningAddress getDefaultAddress(Long userId);

    LotteryWinningAddress selectAddressOne(Long activityId, Long userId);
}
