package com.link.hub.service.weChatMiniProgram;

import com.baomidou.mybatisplus.extension.service.IService;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryParticipate;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinningAddress;
import com.link.hub.pojo.mp.bo.LotteryParticipateBo;
import com.link.hub.pojo.mp.bo.LotteryWinningAddresssBo;
import com.link.hub.pojo.mp.vo.LotteryParticipateVo;
import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.pojo.mp.vo.MyLotteryVo;

import java.util.List;

/**
 * 用户参与抽奖记录Service接口
 */
public interface LotteryParticipateService extends IService<LotteryParticipate> {
    /**
     * 参与抽奖活动
     *
     * @param lotteryVo 参与信息
     * @return 是否成功
     */
    LotteryParticipate participateLottery(LotteryParticipateBo lotteryVo);

    /**
     * 检查用户是否已参与活动
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 是否参与
     */
    boolean checkUserParticipated(Long activityId, Long userId);

    /**
     * 获取用户参与记录列表
     *
     * @param userId 用户ID
     * @return 参与记录列表
     */
    List<LotteryParticipateVo> getUserParticipateList(Long userId);

    /**
     * 获取用户参与的活动数量
     * @param userId 用户ID
     * @return 参与数量
     */
    int getUserParticipateCount(Long userId);


    List<MyLotteryVo> queryMyRecord();

    LotteryVo queryLotteryInfo(Long activityId);

    List<LotteryVo> queryList();

    LotteryWinningAddress participateLotteryAddress(LotteryWinningAddresssBo lotteryParticipateBo);

    List<LotteryVo> announcementList();
}
