package com.link.hub.service.weChatMiniProgram;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.pojo.mp.vo.LotteryVo;

import java.util.List;

/**
 * 抽奖活动服务接口
 */
public interface LotteryActivityService extends IService<LotteryActivity> {
    /**
     * 查询当前有效的活动列表
     * @param status 活动状态
     * @param pageNum 页码
     * @param pageSize 分页大小
     * @return 分页结果
     */
    IPage<LotteryActivity> queryActiveActivities(Integer status, Integer pageNum, Integer pageSize);

    /**
     * 根据ID查询活动详情
     * @param activityId 活动ID
     * @return 活动详情
     */
    LotteryActivity getDetailById(Long activityId);

    /**
     * 创建抽奖活动
     * @param activity 活动参数
     * @return 是否成功
     */
    boolean createActivity(LotteryActivity activity);

    /**
     * 更新抽奖活动
     * @param activity 活动参数
     * @return 是否成功
     */
    boolean updateActivity(LotteryActivity activity);
    List<LotteryActivity> queryActiveActivityList();

    List<LotteryVo> queryList();


}
