// 包路径：com.link.hub.application.service
package com.link.hub.service.officeAccount;

import com.link.hub.domain.weChatOfficialAccount.entity.WechatOfficialAccountUser;
import com.link.hub.pojo.oa.dto.WeChatOaUserQueryDto;
import com.link.hub.pojo.oa.dto.WechatOaUserDto;
import com.link.hub.pojo.oa.dto.WechatOaUserResDto;

import java.util.List;

/**
 * 微信公众号用户 服务接口
 */
public interface WechatOfficialAccountUserService {
    /**
     * 根据 openId 获取用户信息
     * @param openId 公众号用户唯一标识
     * @return 用户实体
     */
    WechatOfficialAccountUser getUserByOpenId(String openId);

    /**
     * 保存或更新用户信息
     * @param user 用户实体
     * @return 操作结果
     */
    boolean saveOrUpdateUser(WechatOfficialAccountUser user);

    void saveOrUpdateBatch(List<WechatOaUserDto> officialAccountUsers);

    WechatOfficialAccountUser selectMaxIdUser();

    List<WechatOaUserDto> selectPageList(Integer pageNum, Integer pageSize);

    void updateUserInfoBatch(List<WechatOaUserResDto> userInfoBatch);

    WechatOfficialAccountUser selectOne(WeChatOaUserQueryDto oaUserDto);
}
