package com.link.hub.pojo.mp.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryParticipate;
import com.link.hub.domain.weChatMiniProgram.enums.LotteryStatusEnum;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class MyLotteryVo {
    /**
     * 抽奖id
     */
    private Long id;
    /**
     * 抽奖活动名称
      */
    private String title;
    /**
     * 抽奖描述
      */
    private String description;
    /**
     * 抽奖图片
      */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String coverImg;
    /**
     * 抽奖开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;
    /**
     * 抽奖结束时间
      */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联用户ID
     */
    private Long userId;
    /**
     * 抽奖状态
     * 0未参与 1 已参与（待开奖）   2未中奖,  3已中奖 -未填写收获地址  4已中奖-已填写待发货 5已中奖-已发货 6已中奖-未领奖
     * @see LotteryStatusEnum
     */
    private Integer lotteryStatus;

    /**
     * 开奖时间
     * @param participate
     * @return
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lotteryTime;
    /**
     * 中奖奖品名称
     */
    private String lotteryPrizeName;
    /**
     * 中奖奖品图片
     */
    private String lotteryPrizeImg;
     /**
      * 中奖等级
      */
     private Integer winningLevel;
    /**
      * 物流单号
      */
     private String logisticsNumber;


    public static MyLotteryVo convert4LotteryParticipate(LotteryParticipate participate) {
        MyLotteryVo vo = new MyLotteryVo();
        vo.setId(participate.getId());
        vo.setActivityId(participate.getActivityId());
        vo.setUserId(participate.getUserId());
        vo.setLotteryStatus(participate.getLotteryStatus());
        vo.setLotteryTime(participate.getLotteryTime());
        vo.setTitle(participate.getTitle());

        return vo;
    }
}

