package com.link.hub.pojo.mp.vo;

import lombok.Data;

/**
 * 抽奖信息
 */
@Data
public class LotteryVo {

    /**
     * 抽奖活动信息
     */
    private LotteryActivityVo activity;
    /**
     * 中奖信息
     */
    private LotteryWinningVo winning;
    /**
     * 抽奖活动id
     */
    private Long activityId;
    /**
     * 抽奖来源：1微信小程序2抖音小程序
     */
    private Integer source;

    private String sourceName;

    /**
     * 抽奖状态
     * 0未参与 1 已参与（待开奖）   2未中奖,  3已中奖 -未填写收获地址  4已中奖-已填写待发货 5已中奖-已发货 6已中奖-未领奖
     */
    private Integer status;


    /**
     * 未参与抽奖
     * @return
     */
    public static LotteryVo convertNoParticipate() {
        LotteryVo lotteryVo = new LotteryVo();
        lotteryVo.setStatus(0);
        return lotteryVo;
    }
}

