package com.link.hub.pojo.mp.dto;

import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinning;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 用户中奖记录DTO
 */
@Data
public class LotteryWinningDto {

    /**
     * 中奖记录ID
     */
    private Long id;

    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联奖品ID
     */
    private Long prizeId;

    /**
     * 关联用户ID
     */
    private Long userId;

    /**
     * 中奖时间
     */
    private LocalDateTime winningTime;

    /**
     * 是否领奖：0-未领奖 1-已领奖 2-已作废
     */
    private Integer isReceive;

    /**
     * 领奖时间
     */
    private LocalDateTime receiveTime;



    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人（用户ID/系统）
     */
    private String createBy;

    /**
     * 修改人（管理员ID/用户ID）
     */
    private String updateBy;

    /**
     * 是否删除：0-未删除 1-已删除
     */
    private Integer deleteFlag;

    /**
     * 将实体类转换为DTO
     */
    public static LotteryWinningDto convert(LotteryWinning entity) {
        if (entity == null) {
            return null;
        }

        LotteryWinningDto dto = new LotteryWinningDto();
        dto.setId(entity.getId());
        dto.setActivityId(entity.getActivityId());
        dto.setPrizeId(entity.getPrizeId());
        dto.setUserId(entity.getUserId());
        dto.setWinningTime(entity.getWinningTime());
        dto.setIsReceive(entity.getIsReceive());
        dto.setReceiveTime(entity.getReceiveTime());
        dto.setCreateTime(entity.getCreateTime());
        dto.setUpdateTime(entity.getUpdateTime());
        dto.setCreateBy(entity.getCreateBy());
        dto.setUpdateBy(entity.getUpdateBy());
        dto.setDeleteFlag(entity.getDeleteFlag());

        return dto;
    }

    /**
     * 将DTO转换为实体类
     */
    public static LotteryWinning convert(LotteryWinningDto dto) {
        if (dto == null) {
            return null;
        }

        LotteryWinning entity = new LotteryWinning();
        entity.setId(dto.getId());
        entity.setActivityId(dto.getActivityId());
        entity.setPrizeId(dto.getPrizeId());
        entity.setUserId(dto.getUserId());
        entity.setWinningTime(dto.getWinningTime());
        entity.setIsReceive(dto.getIsReceive());
        entity.setReceiveTime(dto.getReceiveTime());
        entity.setCreateTime(dto.getCreateTime());
        entity.setUpdateTime(dto.getUpdateTime());
        entity.setCreateBy(dto.getCreateBy());
        entity.setUpdateBy(dto.getUpdateBy());
        entity.setDeleteFlag(dto.getDeleteFlag());

        return entity;
    }
}
