package com.link.hub.pojo.mp.dto;

import lombok.Data;
import java.time.LocalDateTime;

/**
 * 中奖记录-物流地址关联表DTO
 */
@Data
public class LotteryWinningAddressDto {

    /**
     * 地址记录主键ID
     */
    private Long id;

    /**
     * 关联中奖记录ID
     */
    private Long winningId;

    /**
     * 关联用户ID（便于查询用户所有地址）
     */
    private Long userId;

    /**
     * 收货地址-省
     */
    private String province;

    /**
     * 收货地址-市
     */
    private String city;

    /**
     * 收货地址-详细地址（区/街道/门牌号）
     */
    private String detailAddress;

    /**
     * 收货人姓名
     */
    private String receiverName;

    /**
     * 收货人手机号（AES加密存储）
     */
    private String receiverPhone;

    /**
     * 是否默认地址：0-否 1-是
     */
    private Integer isDefault;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人（用户ID/系统）
     */
    private String createBy;

    /**
     * 修改人（用户ID/管理员ID）
     */
    private String updateBy;

    /**
     * 是否删除：0-未删除 1-已删除
     */
    private Integer deleteFlag;
}
