package com.link.hub.pojo.mp.dto;

import cn.hutool.core.util.ObjectUtil;
import com.link.hub.domain.weChatMiniProgram.enums.SourceEnum;
import com.link.hub.pojo.mp.bo.LotteryParticipateBo;
import com.sfa.common.core.utils.ip.IpUtils;
import com.sfa.common.security.utils.SecurityUtils;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 用户参与抽奖记录DTO类
 */
@Data
public class LotteryParticipateDto {
    /**
     * 关联活动ID
     */
    @NotNull(message = "活动ID不能为空")
    private Long activityId;

    /**
     * 关联用户ID
     */
    @NotNull(message = "用户ID不能为空")
    private Long userId;

    /**
     * 参与IP
     */
    private String ipAddress;

    /**
     * 设备标识
     */
    private String deviceInfo;

    /**
     * 参与来源：1微信小程序2抖音小程序
     */
    private Integer source;
    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动开奖时间
     */
    private LocalDateTime lotteryTime;



    // 核心业务规则：创建订单（封装状态初始化、金额计算）
    public static LotteryParticipateDto convert(LotteryParticipateBo participateBo ) {
        LotteryParticipateDto dto = new LotteryParticipateDto();
        dto.setActivityId(participateBo.getActivityId());
        dto.setUserId(SecurityUtils.getUserId());
        dto.setSource(ObjectUtil.defaultIfNull(participateBo.getSource(), SourceEnum.WECHAT_MINI_PROGRAM.getCode()));
        dto.setIpAddress(IpUtils.getIpAddr());

        dto.setLotteryTime(participateBo.getLotteryTime());
        dto.setTitle(participateBo.getTitle());
        return dto;
    }
}
