package com.link.hub.pojo.mp.bo;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 用户参与抽奖BO类
 */
@Data
public class LotteryWinningAddresssBo {
    private Long id;

    /**
     * 关联活动ID
     */
    @NotNull(message = "活动ID不能为空")
    private Long activityId;

    /**
     * 收货地址-省
     */
    @NotNull(message = "省不能为空")
    private String province;
    /**
     * 收货地址-市
     */
    @NotNull(message = "市不能为空")
    private String city;
    /**
     * 收货地址-区
     */
    @NotNull(message = "区不能为空")
    private String district;
    /**
     * 收货地址-详细地址（区/街道/门牌号）
     */
    @NotNull(message = "详细地址不能为空")
    private String detailAddress;
    /**
     * 收货人姓名
     */
    @NotNull(message = "收货人姓名不能为空")
    private String receiverName;
    /**
     * 收货人手机号（AES加密存储）
     */
    @NotNull(message = "收货人手机号不能为空")
    private String receiverPhone;
    /**
     * 是否默认地址：0-否 1-是
     */
    @NotNull(message = "是否默认地址不能为空")
    private Integer isDefault;


}
