package com.link.hub.pojo.mp.bo;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 用户参与抽奖BO类
 */
@Data
public class LotteryParticipateBo {
    /**
     * 关联活动ID
     */
    @NotNull(message = "活动ID不能为空")
    private Long activityId;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动开奖时间
     */
    private LocalDateTime lotteryTime;



    /**
     * 关联用户ID
     */
    @NotNull(message = "用户ID不能为空")
    private Long userId;

    /**
     * 参与IP
     */
    private String ipAddress;

    /**
     * 设备标识
     */
    private String deviceInfo;

    /**
     * 参与来源：1微信小程序2抖音小程序
     */
    private Integer source;
}
