package com.link.hub.domain.weChatOfficialAccount.dao;

import com.link.hub.domain.weChatOfficialAccount.entity.WechatOfficialAccountUser;
import com.link.hub.domain.weChatOfficialAccount.mq.WeChatOaUserQueryWq;
import com.link.hub.pojo.oa.dto.WechatOaUserDto;
import com.link.hub.pojo.oa.dto.WechatOaUserResDto;
import com.sfa.common.core.web.domain.PageInfo;

import java.util.List;
import java.util.Set;

/**
 * 微信公众号用户 DAO 接口
 */
public interface WechatOfficialAccountUserDao {
    /**
     * 根据openid查询用户
     */
    WechatOfficialAccountUser getUserByOpenId(String openId);

    /**
     * 保存或更新用户
     */
    boolean saveOrUpdateUser(WechatOfficialAccountUser user);


    void updateBatch(List<WechatOaUserDto> officialAccountUsers);

    void saveBatch(List<WechatOaUserDto> officialAccountUsers);

    List<WechatOfficialAccountUser> selectByOpenIds(Set<String> allOpenIds);

    List<WechatOfficialAccountUser> selectList();

    PageInfo selectPageList(Integer pageNum, Integer pageSize);

    void updateUserInfoBatch(List<WechatOaUserResDto> userInfoBatch);

    WechatOfficialAccountUser selectOne(WeChatOaUserQueryWq wq);
}
