package com.link.hub.domain.weChatMiniProgram.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 抽奖活动状态枚举
 */
@Getter
@AllArgsConstructor
public enum LotteryStatusEnum {
    /**
     * 0未参与 1 已参与（待开奖） 2未中奖
     * 3已中奖-未填写收获地址 4已中奖-已填写待发货
     * 5已中奖-已发货 6已中奖-未领奖 7已中奖-已领奖
     */
    NOT_PARTICIPATED(0, "未参与", false),
    PARTICIPATED_PENDING(1, "已参与（待开奖）", false),
    NOT_WIN(2, "未中奖", false),
    WIN_NO_ADDRESS(3, "已中奖-未填写收获地址", true),
    WIN_PENDING_SHIPMENT(4, "已中奖-已填写待发货", true),
    WIN_SHIPPED(5, "已中奖-已发货", true),
    WIN_NOT_RECEIVED(6, "已中奖-未领奖", true);

    /**
     * 状态码
     */
    private final Integer code;

    /**
     * 状态描述
     */
    private final String desc;

    /**
     * 是否中奖
     */
    private final boolean isWinning;

    /**
     * 根据状态码获取枚举
     */
    public static LotteryStatusEnum getEnumByCode(Integer code) {
        for (LotteryStatusEnum status : values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }
}
