package com.link.hub.domain.weChatMiniProgram.entity;

import cn.hutool.crypto.digest.DigestUtil;
import com.baomidou.mybatisplus.annotation.*;
import com.link.hub.pojo.mp.bo.LotteryWinningAddresssBo;
import com.sfa.common.security.utils.SecurityUtils;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 中奖记录-物流地址关联表实体类
 */
@Data
@TableName("lottery_winning_address")
public class LotteryWinningAddress {

    /**
     * 地址记录主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 关联中奖记录ID
     */
    private Long winningId;
    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联用户ID（便于查询用户所有地址）
     */
    private Long userId;
    /**
     * 物流单号
     */
    private String logisticsNumber;

    /**
     * 收货地址-省
     */
    private String province;

    /**
     * 收货地址-市
     */
    private String city;
    /**
     * 收货地址-区县
     */
    private String district;

    /**
     * 收货地址-详细地址（区/街道/门牌号）
     */
    private String detailAddress;

    /**
     * 收货人姓名
     */
    private String receiverName;

    /**
     * 收货人手机号（AES加密存储）
     */
    private String receiverPhone;

    /**
     * 是否默认地址：0-否 1-是
     */
    private Integer isDefault;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    /**
     * 创建人（用户ID/系统）
     */
    private String createBy;

    /**
     * 修改人（用户ID/管理员ID）
     */
    private String updateBy;

    /**
     * 是否删除：0-未删除 1-已删除
     */
    @TableLogic
    private Integer deleteFlag;

    public static LotteryWinningAddress create(LotteryWinningAddresssBo lotteryParticipateBo) {
        LotteryWinningAddress  address= new LotteryWinningAddress();
        // 编辑时有id 则为修改操作
        if (lotteryParticipateBo.getId() != null) {
            address.setId(lotteryParticipateBo.getId());
        }

        address.setActivityId(lotteryParticipateBo.getActivityId());
        address.setUserId(SecurityUtils.getUserId());
        address.setProvince(lotteryParticipateBo.getProvince());
        address.setCity(lotteryParticipateBo.getCity());
        address.setDistrict(lotteryParticipateBo.getDistrict());
        address.setDetailAddress(lotteryParticipateBo.getDetailAddress());
        address.setReceiverName(lotteryParticipateBo.getReceiverName());
        // 手机号加密存储
        String boReceiverPhone = lotteryParticipateBo.getReceiverPhone();
        String encryptedPhone = DigestUtil.md5(boReceiverPhone, "UTF-8").toString();
        address.setReceiverPhone(encryptedPhone);
        address.setIsDefault(lotteryParticipateBo.getIsDefault());
        return address;

    }
}
