package com.link.hub.domain.weChatMiniProgram.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.link.hub.pojo.mp.dto.LotteryWinningDto;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 用户中奖记录实体类
 */
@Data
@TableName("lottery_winning")
public class LotteryWinning {

    /**
     * 中奖记录ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联奖品ID
     */
    private Long prizeId;

    /**
     * 关联用户ID
     */
    private Long userId;

    /**
     * 中奖时间
     */
    private LocalDateTime winningTime;

    /**
     * 是否领奖：0-未领奖 1-已领奖 2-已作废
     */
    private Integer isReceive;
    /**
     * 领奖物流单号
     */
    private String logisticsNumber;

    /**
     * 领奖时间
     */
    private LocalDateTime receiveTime;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    /**
     * 创建人（用户ID/系统）
     */
    private String createBy;

    /**
     * 修改人（管理员ID/用户ID）
     */
    private String updateBy;

    /**
     * 是否删除：0-未删除 1-已删除
     */
    @TableLogic
    private Integer deleteFlag;

    /**
     * 中奖物品名称
     */
    private String prizeName;
    /**
     *  中奖等级：1-一等奖 2-二等奖 3-三等奖
     */
    private Integer winningLevel;
    /**
     * 中奖奖品图片URL
     */
    private String prizeImg;
    public static LotteryWinning convert(LotteryWinningDto lotteryWinningDto) {
        LotteryWinning lotteryWinning = new LotteryWinning();
        lotteryWinning.setId(lotteryWinningDto.getId());

        lotteryWinning.setActivityId(lotteryWinningDto.getActivityId());
        lotteryWinning.setPrizeId(lotteryWinningDto.getPrizeId());
        lotteryWinning.setUserId(lotteryWinningDto.getUserId());
        lotteryWinning.setWinningTime(lotteryWinningDto.getWinningTime());
        lotteryWinning.setIsReceive(lotteryWinningDto.getIsReceive());
        lotteryWinning.setReceiveTime(lotteryWinningDto.getReceiveTime());
        return lotteryWinning;
    }
}

