package com.link.hub.domain.weChatMiniProgram.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 抽奖活动配置实体类
 */
@Data
@TableName("lottery_activity")
public class LotteryActivity {
    /**
     * 活动ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动封面图URL
     */
    private String coverImg;

    /**
     * 活动开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;
    /**
     * 开奖时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime lotteryTime;


    /**
     * 活动状态：0-未开始 1-进行中 2-已结束 3-已下架
     */
    private Integer status;

    /**
     * 活动规则（富文本）
     */
    private String ruleDesc;

    /**
     * 单用户最多参与次数（0=无限制）
     */
    private Integer maxParticipateNum;

    /**
     * 累计参与人数
     */
    private Long totalParticipate;

    /**
     * 创建时间
     */
//    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
//    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;


    /**
     * 创建人
     */
    private String createBy;

    /**
     * 修改人
     */
    private String updateBy;

    /**
     * 逻辑删除标识
     */
    private Integer deleteFlag;

}
