package com.link.hub.domain.weChatMiniProgram.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryWinningDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinning;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryWinningMapper;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户中奖记录数据访问层实现类
 */
@Repository
public class LotteryWinningDaoImpl implements LotteryWinningDao {

    @Resource
    private LotteryWinningMapper lotteryWinningMapper;

    @Override
    public List<LotteryWinning> queryList(LotteryWinningWq wq) {
        QueryWrapper<LotteryWinning> wrapper = new QueryWrapper<>();

        if (wq.getActivityId() != null) {
            wrapper.eq("activity_id", wq.getActivityId());
        }
        if (wq.getUserId() != null) {
            wrapper.eq("user_id", wq.getUserId());
        }
        if (wq.getIsReceive() != null) {
            wrapper.eq("is_receive", wq.getIsReceive());
        }
        if (wq.getWinningTimeStart() != null && wq.getWinningTimeEnd() != null) {
            wrapper.between("winning_time", wq.getWinningTimeStart(), wq.getWinningTimeEnd());
        }
        wrapper.eq("delete_flag", wq.getDeleteFlag());

        return lotteryWinningMapper.selectList(wrapper);
    }

    @Override
    public LotteryWinning selectById(Long id) {
        return lotteryWinningMapper.selectById(id);
    }

    @Override
    public int insert(LotteryWinning lotteryWinning) {
        return lotteryWinningMapper.insert(lotteryWinning);
    }

    @Override
    public int updateById(LotteryWinning lotteryWinning) {
        return lotteryWinningMapper.updateById(lotteryWinning);
    }

    @Override
    public int deleteById(Long id) {
        return lotteryWinningMapper.deleteById(id);
    }

    @Override
    public List<LotteryWinning> queryUserWinningRecords(Long activityId, Long userId) {
        LambdaQueryWrapper<LotteryWinning> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryWinning::getActivityId, activityId)
               .eq(LotteryWinning::getUserId, userId)
               .eq(LotteryWinning::getDeleteFlag, 0);
        return lotteryWinningMapper.selectList(wrapper);
    }

    @Override
    public long countWinningByActivity(Long activityId) {
        LambdaQueryWrapper<LotteryWinning> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryWinning::getActivityId, activityId)
               .eq(LotteryWinning::getDeleteFlag, 0);
        return lotteryWinningMapper.selectCount(wrapper);
    }

    @Override
    public List<LotteryWinning> queryUnreceivedPrizes(Long userId) {
        LambdaQueryWrapper<LotteryWinning> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryWinning::getUserId, userId)
               .eq(LotteryWinning::getIsReceive, 0) // 未领取
               .eq(LotteryWinning::getDeleteFlag, 0);
        return lotteryWinningMapper.selectList(wrapper);
    }

    @Override
    public boolean hasWinning(Long activityId, Long userId) {
        // 获取
        LambdaQueryWrapper<LotteryWinning> wrapper =new LambdaQueryWrapper<LotteryWinning>();
        wrapper.eq(LotteryWinning::getActivityId, activityId)
                .eq(LotteryWinning::getUserId, userId);
        if (lotteryWinningMapper.selectCount(wrapper) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public LotteryWinning getWinningDetail(Long activityId, Long userId) {
        LambdaQueryWrapper<LotteryWinning> wrapper =new LambdaQueryWrapper<LotteryWinning>();
        wrapper.eq(LotteryWinning::getActivityId, activityId)
                .eq(LotteryWinning::getUserId, userId)
                .eq(LotteryWinning::getDeleteFlag, 0);
        return lotteryWinningMapper.selectOne(wrapper);
    }
}
