package com.link.hub.domain.weChatMiniProgram.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryWinningAddressDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinningAddress;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryWinningAddressMapper;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningAddressWq;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 中奖记录-物流地址关联表DAO实现类
 */
@Repository
public class LotteryWinningAddressDaoImpl extends ServiceImpl<LotteryWinningAddressMapper, LotteryWinningAddress> implements LotteryWinningAddressDao {

    private final LotteryWinningAddressMapper lotteryWinningAddressMapper;

    public LotteryWinningAddressDaoImpl(LotteryWinningAddressMapper lotteryWinningAddressMapper) {
        this.lotteryWinningAddressMapper = lotteryWinningAddressMapper;
    }

    @Override
    public List<LotteryWinningAddress> queryList(LotteryWinningWq wq) {
        LambdaQueryWrapper<LotteryWinningAddress> wrapper = new LambdaQueryWrapper<>();

        if (wq.getUserId() != null) {
            wrapper.eq(LotteryWinningAddress::getUserId, wq.getUserId());
        }

        if (wq.getDeleteFlag() != null) {
            wrapper.eq(LotteryWinningAddress::getDeleteFlag, wq.getDeleteFlag());
        }

        wrapper.orderByDesc(LotteryWinningAddress::getCreateTime);
        return lotteryWinningAddressMapper.selectList(wrapper);
    }

    @Override
    public IPage<LotteryWinningAddress> queryPage(Page<LotteryWinningAddress> page, Wrapper<LotteryWinningAddress> wrapper) {
        return lotteryWinningAddressMapper.selectPage(page, wrapper);
    }

    @Override
    public LotteryWinningAddress getById(Long id) {
        return lotteryWinningAddressMapper.selectById(id);
    }

    @Override
    public boolean saveAddress(LotteryWinningAddress address) {
        return lotteryWinningAddressMapper.insert(address) > 0;
    }

    @Override
    public boolean updateAddress(LotteryWinningAddress address) {
        return lotteryWinningAddressMapper.updateById(address) > 0;
    }

    @Override
    public boolean deleteAddress(Long id) {
        LotteryWinningAddress address = new LotteryWinningAddress();
        address.setId(id);
        address.setDeleteFlag(1);
        return lotteryWinningAddressMapper.updateById(address) > 0;
    }

    @Override
    public LotteryWinningAddress getByWinningId(Long winningId) {
        LambdaQueryWrapper<LotteryWinningAddress> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryWinningAddress::getWinningId, winningId)
                .eq(LotteryWinningAddress::getDeleteFlag, 0);
        return lotteryWinningAddressMapper.selectOne(wrapper);
    }

    @Override
    public LotteryWinningAddress getDefaultAddress(Long userId) {
        LambdaQueryWrapper<LotteryWinningAddress> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryWinningAddress::getUserId, userId)
                .eq(LotteryWinningAddress::getIsDefault, 1)
                .eq(LotteryWinningAddress::getDeleteFlag, 0);
        return lotteryWinningAddressMapper.selectOne(wrapper);
    }

    @Override
    public LotteryWinningAddress selectOne(LotteryWinningAddressWq wq) {
        LambdaQueryWrapper<LotteryWinningAddress> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LotteryWinningAddress::getActivityId, wq.getActivityId())
                .eq(LotteryWinningAddress::getUserId, wq.getUserId())
                .eq(LotteryWinningAddress::getDeleteFlag, 0);
        return lotteryWinningAddressMapper.selectOne(wrapper);
    }
}
