package com.link.hub.domain.weChatMiniProgram.dao;

import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinning;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWinningWq;
import java.util.List;

/**
 * 用户中奖记录数据访问层接口
 */
public interface LotteryWinningDao {

    /**
     * 查询中奖记录列表
     */
    List<LotteryWinning> queryList(LotteryWinningWq wq);

    /**
     * 根据ID查询中奖记录
     */
    LotteryWinning selectById(Long id);

    /**
     * 新增中奖记录
     */
    int insert(LotteryWinning lotteryWinning);

    /**
     * 更新中奖记录
     */
    int updateById(LotteryWinning lotteryWinning);

    /**
     * 删除中奖记录（逻辑删除）
     */
    int deleteById(Long id);

    /**
     * 查询用户中奖记录
     */
    List<LotteryWinning> queryUserWinningRecords(Long activityId, Long userId);

    /**
     * 统计活动中奖人数
     */
    long countWinningByActivity(Long activityId);

    /**
     * 查询未领取奖品记录
     */
    List<LotteryWinning> queryUnreceivedPrizes(Long userId);


    boolean hasWinning(Long activityId, Long userId);

    LotteryWinning getWinningDetail(Long activityId, Long userId);
}
