package com.link.hub.domain.weChatMiniProgram.dao;

import com.link.hub.domain.weChatMiniProgram.entity.LotteryParticipate;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryParticipateWq;
import com.link.hub.pojo.mp.dto.LotteryDto;
import com.link.hub.pojo.mp.dto.LotteryParticipateDto;
import com.link.hub.pojo.mp.vo.LotteryVo;

import java.util.List;

/**
 * 用户参与抽奖记录DAO接口
 */
public interface LotteryParticipateDao   {
    List<LotteryParticipate> queryList(LotteryParticipateWq wq);


    /**
     * 检查用户是否已参与活动
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 是否参与
     */
    boolean checkUserParticipated(Long activityId, Long userId);

    /**
     * 获取用户参与的活动数量
     * @param userId 用户ID
     * @return 参与数量
     */
    int getUserParticipateCount(Long userId);
    /**
     * 根据活动ID和用户ID检查是否已参与
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 是否已参与
     */
    boolean hasParticipated(Long activityId, Long userId);

    /**
     * 保存参与记录（含防重校验）
     *
     * @param participateDto 参与记录实体
     * @return 是否成功
     */
    LotteryParticipate saveParticipate(LotteryParticipateDto participateDto);

    /**
     * 查询用户在某活动的参与记录
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 参与记录
     */
    LotteryParticipate getParticipateRecord(Long activityId, Long userId);

    /**
     * 统计活动参与人数
     * @param activityId 活动ID
     * @return 参与人数
     */
    long countParticipateByActivity(Long activityId);




    List<LotteryVo> announcementList();

    LotteryDto queryLotteryInfo(LotteryDto dto);
}
