package com.link.hub.domain.weChatMiniProgram.dao;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.domain.weChatMiniProgram.wq.LotteryWq;
import com.link.hub.pojo.mp.dto.LotteryActivityRelDto;

import java.util.List;

/**
 * 抽奖活动数据访问接口
 */
public interface LotteryActivityDao {
    /**
     * 根据ID查询活动信息
     * @param id 活动ID
     * @return 活动实体
     */
    LotteryActivity getActivityById(Long id);

    /**
     * 查询进行中的活动列表
     * @return 活动列表
     */
    List<LotteryActivity> getOngoingActivities();

    List<LotteryActivity> queryList(LotteryWq wq);

    List<LotteryActivityRelDto> queryMyRecord(LotteryWq wq);

    IPage<LotteryActivity> selectPage(Page<LotteryActivity> page, LambdaQueryWrapper<LotteryActivity> wrapper);

    LotteryActivity selectById(Long activityId);

    List<LotteryActivity> queryActiveActivityList();
}
