package com.link.hub.controller.mp.query;

import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.pojo.mp.vo.MyLotteryVo;
import com.link.hub.service.weChatMiniProgram.LotteryParticipateService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抽奖查询接口
 * @author : lvbencai
 * @date : 2025-12-10
 * @describe : 抽奖查询接口
 */
@RestController
@RequestMapping("/miniProgram/query")
public class LotteryParticipateQueryController {
    @Resource
    private LotteryParticipateService lotteryParticipateService;


    /**
     * 查询抽奖公示信息-包含抽奖列表和详情
      */
    @RequestMapping("/lottery/announcement")
    public List<LotteryVo> announcementList() {
        // 查询活动列表
        List<LotteryVo> lotteryVos = lotteryParticipateService.announcementList();
        return lotteryVos;
    }

    /**
     * 查询抽奖信息
     */
    @GetMapping("/lottery/info")
    public LotteryVo info(Long activityId) {
        // 查询活动列表
        LotteryVo lotteryVo = lotteryParticipateService.queryLotteryInfo(activityId);
        return lotteryVo;
    }


    /**
     * 我的-查询抽奖历史记录
      */
    @GetMapping("/lottery/record")
    public List<MyLotteryVo> record() {
        // 查询活动列表
        List<MyLotteryVo> lotteryVos = lotteryParticipateService.queryMyRecord();
        return lotteryVos;
    }
}
