package com.link.hub.controller.mp.query;

import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.service.weChatMiniProgram.LotteryActivityService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抽奖活动控制器
 */
//@Api(tags = "抽奖活动管理")
@RestController
@RequestMapping("/miniProgram/query")
public class LotteryActivityQueryController {
    @Resource
    private LotteryActivityService lotteryActivityService;

    /**
     * 查询活动列表
     * 小程序端查询上线的list
     */
    @GetMapping("/lottery/list")
    public List<LotteryActivity> listActivities() {
        List<LotteryActivity> activityList = lotteryActivityService.queryActiveActivityList();
        return activityList;
    }
    /**
     * 查询活动详情
     */
    @GetMapping("/activity/info/{id}")
    public LotteryActivity getActivityDetail(@PathVariable Long id) {
        LotteryActivity activity = lotteryActivityService.getDetailById(id);
        return activity;
    }


}
