package com.link.hub.controller.mp.core;

import com.link.hub.domain.weChatMiniProgram.entity.LotteryParticipate;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryWinningAddress;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.pojo.mp.bo.LotteryParticipateBo;
import com.link.hub.pojo.mp.bo.LotteryWinningAddresssBo;
import com.link.hub.pojo.mp.bo.MpUserBo;
import com.link.hub.service.weChatMiniProgram.LotteryParticipateService;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 修改接口-参与抽奖、填写抽奖地址、填写用户信息
 *
 * @author : lvbencai
 * @date : 2025-12-10
 * @describe : 抽奖查询接口
 */
@RestController
@RequestMapping("/miniProgram/core")
public class LotteryCoreController {
    @Resource
    private LotteryParticipateService lotteryParticipateService;
    @Resource
    private WechatMiniProgramUserService mpUserService;


    /**
     * 用户参与抽奖活动
     *
     * @param lotteryParticipateBo
     * @return
     */
    @PostMapping("/lottery")
    public LotteryParticipate participateLottery(@RequestBody LotteryParticipateBo lotteryParticipateBo) {
        return lotteryParticipateService.participateLottery(lotteryParticipateBo);
    }

    /**
     * 用户填写-抽奖地址信息
     *
     * @param lotteryParticipateBo
     * @return
     */
    @PostMapping("/address")
    public LotteryWinningAddress participateLotteryAddress(@RequestBody LotteryWinningAddresssBo lotteryParticipateBo) {
        return lotteryParticipateService.participateLotteryAddress(lotteryParticipateBo);
    }

    /**
     * 用户填写用户头像信息
     *
     * @param mpUserBo
     * @return
     */
    @PostMapping("/userInfo")
    public WechatMiniProgramUser userInfo(@RequestBody MpUserBo mpUserBo) {
        return mpUserService.updateUserInfo(mpUserBo);
    }

}
