package com.link.hub.controller.bms;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryActivity;
import com.link.hub.service.weChatMiniProgram.LotteryActivityService;
import com.sfa.common.core.domain.R;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 后台管理-抽奖活动
 */
 @RestController
@RequestMapping("/manager/query")
public class LotteryActivityQueryManagerController {

    @Resource
    private LotteryActivityService lotteryActivityService;

    /**
     * 查询活动列表
     * 小程序端查询上线的list
     */
    @GetMapping("/activity/list")
    public List<LotteryActivity> listActivities() {
        List<LotteryActivity> activityList = lotteryActivityService.queryActiveActivityList();
        return activityList;
    }


    /**
     * 查询活动列表
     * 后台管理查询
     */
    @GetMapping("/lottery/page")
    public R<?> pageActivities(
            @RequestParam(required = false) Integer status,
            @RequestParam int pageNum,
            @RequestParam int pageSize) {
        IPage<LotteryActivity> page = lotteryActivityService.queryActiveActivities(status, pageNum, pageSize);
        return R.ok(page);
    }


    /**
     * 查询活动详情
     */
    @GetMapping("/{id}")
//    @ApiOperation("查询活动详情")
    public LotteryActivity getActivityDetail(@PathVariable Long id) {
        LotteryActivity activity = lotteryActivityService.getDetailById(id);
        return activity;
    }

    /**
     * 创建抽奖活动
     */
    @PostMapping("/create")
//    @ApiOperation("创建抽奖活动")
    public Boolean createActivity(@RequestBody LotteryActivity activity) {
        boolean result = lotteryActivityService.createActivity(activity);
        return result;
    }

    /**
     * 更新抽奖活动
     */
    @PutMapping("/update")
//    @ApiOperation("更新抽奖活动")
    public Boolean updateActivity(@RequestBody LotteryActivity activity) {
        boolean result = lotteryActivityService.updateActivity(activity);
        return result;
    }
}
