package com.link.hub.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * 腾讯地图配置类
 */
@Configuration
public class TencentMapConfig {

    @Value("${tencent.map.key:UTEBZ-UJ3KG-OORQO-QT3PT-JDWU7-YRBZA}")
    private String tencentMapKey;

    // 腾讯地图逆地理编码API地址
    public static final String TENCENT_MAP_GEOCODER_URL = "https://apis.map.qq.com/ws/geocoder/v1/";
    // 替换为你申请的腾讯地图Key
    public static final String TENCENT_MAP_KEY = "UTEBZ-UJ3KG-OORQO-QT3PT-JDWU7-YRBZA";

    // 注入RestTemplate（用于发送HTTP请求）
    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}
