package com.link.hub.domain.weChatMiniProgram.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 抽奖活动配置实体类
 */
@Data
@TableName("lottery_activity")
public class LotteryActivity {
    /**
     * 活动ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动封面图URL
     */
    private String coverImg;

    /**
     * 活动开始时间
     */
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 活动状态：0-未开始 1-进行中 2-已结束 3-已下架
     */
    private Integer status;

    /**
     * 活动规则（富文本）
     */
    private String ruleDesc;

    /**
     * 单用户最多参与次数（0=无限制）
     */
    private Integer maxParticipateNum;

    /**
     * 累计参与人数
     */
    private Long totalParticipate;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    /**
     * 创建人（管理员账号）
     */
    private String createBy;

    /**
     * 修改人（管理员账号）
     */
    private String updateBy;

    /**
     * 是否删除：0-未删除 1-已删除
     */
    @TableLogic
    private Integer deleteFlag;
}
