package com.link.hub.controller.mp.query;

import com.link.hub.pojo.mp.vo.MiniProgramOpenIdVO;
import com.link.hub.service.officeAccount.WechatOfficeAccountService;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author : liqiulin
 * @date : 2025-03-07 13
 * @describe :
 */
@RestController
@RequestMapping("/miniProgram")
public class WechatMiniProgramController {

    @Resource
    private WechatMiniProgramService wechatMiniProgramService;
    @Resource
    private WechatOfficeAccountService wechatOfficeAccountService;
    @PostMapping("/login")
    public MiniProgramOpenIdVO getUserInfo(String code) {
        MiniProgramOpenIdVO userInfo = wechatMiniProgramService.getUserInfo(code);
        return userInfo;
    }

    /**
     * 是否关注公众号
     * @param openid
     */
    @GetMapping("/isSubscribe")
    public Boolean isSubscribe(String openid) {
        return wechatOfficeAccountService.isSubscribe(openid);
    }


}
