package com.link.hub.pojo.mp.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class MyLotteryVo {
    /**
     * 抽奖id
     */
    private Long id;
    /**
     * 抽奖名称
      */
    private String title;
    /**
     * 抽奖描述
      */
    private String description;
    /**
     * 抽奖图片
      */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String coverImg;
    /**
     * 抽奖开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;
    /**
     * 抽奖结束时间
      */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;


    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联用户ID
     */
    private Long userId;
    /**
     * 抽奖状态
     * 0-未参与 1-已参与（待开奖）   2-未中奖,  3-已中奖 4、未填写收获地址  5已填写-待发货 6已发货
     */
    private Integer lotteryStatus;
}

