package com.link.hub.domain.weChatOfficialAccount.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信公众号用户表 POJO/PO
 * 对应表：wechat_official_account_user
 */
@Data // Lombok注解：自动生成get/set/toString/equals/hashCode
@TableName("wechat_official_account_user") // MyBatis-Plus绑定数据库表名
public class WechatOfficialAccountUser implements Serializable {
    private static final long serialVersionUID = 1L; // 序列化版本号

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO) // 主键自增，匹配MySQL的AUTO_INCREMENT
    private Long id;

    /**
     * 公众号用户唯一标识
     */
    @TableField("openid") // 字段映射（若驼峰匹配可省略，此处显式标注更清晰）
    private String openid;

    /**
     * 微信开放平台统一标识
     */
    @TableField("unionid")
    private String unionid;

    /**
     * 用户昵称
     */
    @TableField("nickname")
    private String nickname;

    /**
     * 用户头像URL
     */
    @TableField("avatar_url")
    private String avatarUrl;

    /**
     * 性别：0-未知，1-男，2-女
     */
    @TableField("sex")
    private Integer sex;

    /**
     * 关注状态：1-已关注，0-已取消关注
     */
    @TableField("subscribe_status")
    private Integer subscribeStatus;

    /**
     * 关注时间
     */
    @TableField("subscribe_time")
    private Date subscribeTime;

    /**
     * 取消关注时间
     */
    @TableField("unsubscribe_time")
    private Date unsubscribeTime;

    /**
     * 公众号运营者给用户的备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 用户所在国家
     */
    @TableField("country")
    private String country;

    /**
     * 用户所在省份
     */
    @TableField("province")
    private String province;

    /**
     * 用户所在城市
     */
    @TableField("city")
    private String city;

    /**
     * 用户语言（zh-CN/zh-TW/en等）
     */
    @TableField("language")
    private String language;

    /**
     * 记录创建时间（MySQL默认CURRENT_TIMESTAMP）
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT) // 插入时自动填充
    private Date createTime;

    /**
     * 记录更新时间（MySQL默认ON UPDATE CURRENT_TIMESTAMP）
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE) // 插入/更新时自动填充
    private Date updateTime;
}
