package com.link.hub.domain.weChatMiniProgram.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.link.hub.pojo.mp.dto.LotteryParticipateDto;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 用户参与抽奖记录表实体类
 */
@Data
@TableName("lottery_participate")
public class LotteryParticipate {
    /**
     * 参与记录ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联用户ID
     */
    private Long userId;
    /**
     * 抽奖状态
     * 0-未参与 1-已参与（待开奖）   2-未中奖,  3-已中奖 4、未填写收获地址  5已填写-待发货 6已发货
     */
    private Integer lotteryStatus;

    /**
     * 参与时间
     */
    private LocalDateTime participateTime;

    /**
     * 参与IP（防作弊）
     */
    private String ipAddress;

    /**
     * 设备标识（防作弊）
     */
    private String deviceInfo;

    /**
     * 参与来源：微信小程序、抖音小程序 1微信小程序2抖音小程序
     */
    private Integer source;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人（用户ID/系统）
     */
    private String createBy;

    /**
     * 修改人（用户ID/系统）
     */
    private String updateBy;

    /**
     * 是否删除：0-未删除 1-已删除
     */
    @TableLogic
    private Integer deleteFlag;


    // 核心业务规则：创建订单（封装状态初始化、金额计算）
    public static LotteryParticipate create(LotteryParticipateDto dto) {
        LotteryParticipate lotteryParticipate = new LotteryParticipate();

        lotteryParticipate.setActivityId(dto.getActivityId());
        lotteryParticipate.setUserId(dto.getUserId());
         // 默认状态为1 已参与待开奖
        lotteryParticipate.setLotteryStatus(1);
        lotteryParticipate.setParticipateTime(LocalDateTime.now());
        lotteryParticipate.setIpAddress(dto.getIpAddress());
        lotteryParticipate.setDeviceInfo(dto.getDeviceInfo());
        lotteryParticipate.setSource(dto.getSource());
        return lotteryParticipate;
    }
}
