package com.link.hub.service.weChatMiniProgram.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson2.JSONObject;
import com.link.hub.config.WeChatMiniProgramConfig;
import com.link.hub.pojo.weChatMiniProgram.vo.MiniProgramOpenIdVO;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramService;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.utils.JwtUtils;
import com.sfa.common.core.utils.ip.IpUtils;
import com.sfa.common.core.utils.uuid.IdUtils;
import com.sfa.common.core.utils.wechat.TencentUtils;
import com.sfa.common.security.service.TokenService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;


/**
 * 小程序服务实现
 */
@Service
public class WechatMiniProgramServiceServiceImpl implements WechatMiniProgramService {
    @Resource
    private WeChatMiniProgramConfig weChatMiniProgramConfig;
    @Resource
    private WechatMiniProgramUserService miniProgramUserService;
    @Resource
    private TokenService tokenService;
    @Value("${mini.program.jwt.expire:720}")
    private Long expireTime;

    @Override
    public MiniProgramOpenIdVO getUserInfo(String code) {
        JSONObject jsonObject = TencentUtils.getOpenid(code, weChatMiniProgramConfig.getAppId(), weChatMiniProgramConfig.getAppSecret());
        // 从jsonObject中获取openid
        String openid = jsonObject.getString("openid");
        String unionid = jsonObject.getString("unionid");
        // 返回结果
        MiniProgramOpenIdVO miniProgramOpenIdVO = new MiniProgramOpenIdVO();
        miniProgramOpenIdVO.setOpenid(openid);
        miniProgramOpenIdVO.setUnionid(unionid);
        // 查询是否关注了微信公众号
//        miniProgramOpenIdVO.setSubscribeFlag(true);
        miniProgramOpenIdVO.setSubscribeTime(DateUtil.date());
        // 保存小程序用户信息
//        String userId = miniProgramUserService.saveMiniProgramUser(openid);
        LoginUser loginUser = new LoginUser();
        String token = IdUtils.fastUUID();

        Long userId = 1L;
        String userName = "openid";
        loginUser.setToken(token);
        loginUser.setUserid(userId);
        loginUser.setUsername(userName);
        loginUser.setIpaddr(IpUtils.getIpAddr());
        tokenService.saveToken(loginUser, expireTime);

        // 返回token
        Map<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put(SecurityConstants.USER_KEY, token);
        claimsMap.put(SecurityConstants.DETAILS_USER_ID, userId);
        claimsMap.put(SecurityConstants.DETAILS_USERNAME, userName);
        // 接口返回信息
        Map<String, Object> rspMap = new HashMap<String, Object>();
        rspMap.put("access_token", JwtUtils.createToken(claimsMap));
        rspMap.put("expires_in", expireTime);
        loginUser.setLoginTime(System.currentTimeMillis());
        miniProgramOpenIdVO.setToken(JwtUtils.createToken(claimsMap));
        return miniProgramOpenIdVO;
    }
}
