package com.link.bi.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.domain.dao.IProductDao;
import com.link.bi.domain.entity.PrdInfo;
import com.link.bi.domain.mapper.PrdInfoMapper;
import com.link.bi.domain.mapper.PrdSeriesMapper;
import com.link.bi.domain.wq.ProductWq;
import com.link.bi.pojo.response.PrdInfoDto;
import com.sfa.common.core.enums.StatusType;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */
@Service
public class ProductDaoImpl implements IProductDao {
    @Autowired
    PrdInfoMapper prdInfoMapper;
    @Autowired
    PrdSeriesMapper prdSeriesMapper;

    @Override
    public List selectSeriesList() {
        List<Map<String, Object>> maps = prdSeriesMapper.selectListByStatus(StatusType.VALID.getType());
        return maps;
    }

    @Override
    public PageInfo productPage(ProductWq pqw) {
        LambdaQueryWrapper<PrdInfo> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(pqw.getSeriesId())){
            qw.eq(PrdInfo::getSeriesId,pqw.getSeriesId());
        }
        if (StringUtils.isNotBlank(pqw.getPrdCode())){
            qw.eq(PrdInfo::getPrdCode,pqw.getPrdCode());
        }
        if (StringUtils.isNotBlank(pqw.getPrdNameLike())){
            qw.like(PrdInfo::getPrdName,pqw.getPrdNameLike());
        }

        Page<PrdInfo> page = prdInfoMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo<>(page);
    }

    @Override
    public List<PrdInfoDto> selectListByIds(List<Integer> ids) {
        List<PrdInfo> prdInfos = prdInfoMapper.selectBatchIds(ids);
        return BeanUtils.transitionDtos(prdInfos, PrdInfoDto.class);
    }

    @Override
    public List<PrdInfoDto> selectListByCodes(List<String> prdCodes) {
        List<PrdInfo> prdInfos = prdInfoMapper.selectList(new LambdaQueryWrapper<PrdInfo>().in(ObjectUtil.isNotEmpty(prdCodes),PrdInfo::getPrdCode, prdCodes));
        return BeanUtils.transitionDtos(prdInfos, PrdInfoDto.class);
    }
}
