package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
/**
 * CollectErrorInfo 类表示采集错误记录，与数据库表 market_bi.collect_error_info 相对应。
 * 包含了采集错误记录的各种信息，如唯一键、入参信息、类型、采集时间、删除标志、创建和更新的用户及时间等。
 */
@TableName(value ="collect_error_log")
@Data
public class CollectErrorLog {



        /**
         * 唯一键，自动递增
         */
        @TableId(type = IdType.AUTO)
        private Long ceiId;

        /**
         * 入参信息，存储为 JSON 格式
         */
        private Map<String, Object> param;

        /**
         * 类型，如 xxljob、影刀等
         */
        private String type;

        /**
         * 采集时间
         */
        private Date collectTime;

        /**
         * 是否删除标志，'0' 表示未删除，'1' 表示已删除
         */
        private char delFlag;

        /**
         * 创建者
         */
        private String createBy;

        /**
         * 创建人 UserID
         */
        private Long createUserId;

        /**
         * 创建时间，默认为当前时间
         */
        private LocalDateTime createTime;

        /**
         * 更新者
         */
        private String updateBy;

        /**
         * 修改人 UserID
         */
        private Long updateUserId;

        /**
         * 更新时间，自动更新为当前时间
         */
        private LocalDateTime updateTime;

        /**
         * 采集批次
         */
        private String batchNo;

        /**
         * 本批次采集开始时间
         */
        private Date startTime;

        /**
         * 本批次采集结束时间
         */
        private Date endTime;
        /**
         * 错误信息
         */
        private String errorMsg;

}
