package com.link.bi.controller.core;

import com.link.bi.service.IEcGoodsSupplyDemandService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 电商-货物供需Controller
 *
 * @author admin
 * @date 2024-12-05
 */
@RestController
@RequestMapping("/demand/core")
public class EcGoodsSupplyDemandCoreController extends BaseController
{
    @Autowired
    private IEcGoodsSupplyDemandService ecGoodsSupplyDemandService;

    /**
     * 导出电商-货物供需列表
     */
    @RequiresPermissions("bi:demand:import")
    @Log(title = "电商-货物供需", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public String importData(HttpServletResponse response, MultipartFile file,Integer year)
    {
        ecGoodsSupplyDemandService.importData(file,year);
        return "导入货需数据完成";
    }
}
