package com.link.bi.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.link.bi.domain.dao.IFinanceOrderDetailDao;
import com.link.bi.domain.entity.FinanceOrderDetail;
import com.link.bi.domain.mapper.FinanceOrderDetailMapper;
import com.link.bi.domain.wq.FinanceCostWq;
import com.link.bi.pojo.request.FinanceCostVo;
import com.link.bi.pojo.response.FinanceBiListDto;
import com.link.bi.pojo.response.FinanceOrderDetailListDto;
import com.link.bi.service.FinanceOrderDetailService;
import com.sfa.common.core.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.stream.Collectors;

/**
 * 旺店通订单明细Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
// 指定不同的数据源
//@DS("bi")
@Slf4j
@Service
public class FinanceOrderDetailServiceImpl extends ServiceImpl<FinanceOrderDetailMapper, FinanceOrderDetail> implements FinanceOrderDetailService {

    @Autowired
    IFinanceOrderDetailDao detailDao;

//      @Autowired
//    WangdiantongOrderService wangdiantongOrderService;


    //    private static final int CORE_POOL_SIZE = 5; // 核心线程数
//    private static final int MAX_POOL_SIZE = 10; // 最大线程数
//    private static final int KEEP_ALIVE_TIME = 60; // 线程空闲时间
//
//    private ExecutorService executorService = Executors.newFixedThreadPool(CORE_POOL_SIZE);
//    @Autowired
//    private Executor customThreadPool;
//    @Autowired
//    private ThreadPoolConfig threadPoolConfig;


    @Override
    public PageInfo<FinanceBiListDto> selectBiFinanceCostList(FinanceCostVo financeCostVo) {
        FinanceCostWq qw = new FinanceCostWq();
        BeanUtils.copyProperties(financeCostVo, qw);
        // 初始化开始日期和结束日期
        if (ObjectUtil.isAllNotEmpty(qw.getStartDate(),qw.getEndDate())) {
            qw.setStartDate(DateUtils.dateStart(DateUtils.dateStart(qw.getStartDate())));
            qw.setEndDate(DateUtils.dateStart(DateUtils.dateStart(DateUtils.addDays(qw.getEndDate(), 1))));
        }else{
            //默认 t-1 天的数据查询
            qw.setStartDate(DateUtils.dateStart(new Date()));
            qw.setEndDate(DateUtils.dateStart(DateUtils.addDays(new Date(),-1)));
        }
        PageInfo<FinanceOrderDetail> orderDetailPageInfo = detailDao.selectBiFinanceCostList(qw);
        PageInfo<FinanceBiListDto> pageInfo = new PageInfo<>();
        BeanUtils.copyProperties(orderDetailPageInfo, pageInfo);
        pageInfo.setList(orderDetailPageInfo.getList().stream().map(item -> {
            FinanceBiListDto dto = new FinanceBiListDto();
            BeanUtils.copyProperties(item, dto);
            dto.setActualCostGrossProfitSum(dto.getShareAmountSum().subtract(dto.getActualCostSum()));
            dto.setStandardCostGrossProfitSum(dto.getShareAmountSum().subtract(dto.getStandardCostSum()));
            dto.setUid(IdUtil.simpleUUID());
            return dto;
        }).collect(Collectors.toList()));
        return pageInfo;
    }

    @Override
    public PageInfo<FinanceOrderDetailListDto> selectBiFinanceCostDetailPage(FinanceCostVo financeCostVo) {
        FinanceCostWq qw = new FinanceCostWq();

        BeanUtils.copyProperties(financeCostVo, qw);
        PageInfo<FinanceOrderDetail> financeOrderDetailPageInfo = detailDao.selectBiFinanceCostDetailList(qw);

        PageInfo<FinanceOrderDetailListDto> pageInfo = new PageInfo<>();
        BeanUtils.copyProperties(financeOrderDetailPageInfo, pageInfo);
        pageInfo.setList(financeOrderDetailPageInfo.getList().stream().map(item -> {
            FinanceOrderDetailListDto dto = new FinanceOrderDetailListDto();
            BeanUtils.copyProperties(item, dto);
            return dto;
        }).collect(Collectors.toList()));
        return pageInfo;
    }


    /**
     * 采集旺店通接口订单明细数据
     *
     * @param startTime
     * @param endTime
     */
//    @Override
//    public void syncWandiantongOrderDetail(Date startTime, Date endTime) {
//        try {

//            wangdiantongOrderService.dealOrders(startTime,endTime);
    // 计算时间间隔
//            long intervalMillis = endTime.getTime() - startTime.getTime();
    // 计算每个线程处理的时、间间隔
//            long threadIntervalMillis = intervalMillis / threadPoolConfig.getMaxPoolSize();
//            List<Future<List<WangdiantongOrder>>> futures = new ArrayList<>();
//            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor) customThreadPool;

    // 创建并提交线程任务
//            List<Callable<List<WangdiantongOrder>>> tasks = new ArrayList<>();
//            for (int i = 0; i < threadPoolConfig.getCorePoolSize(); i++) {
//                Date threadStartTime = new Date(startTime.getTime() + i * threadIntervalMillis);
//                Date threadEndTime = new Date(threadStartTime.getTime() + threadIntervalMillis);
//                Callable<List<WangdiantongOrder>> task = () -> dealOrders(threadStartTime, threadEndTime);
//                tasks.add(task);
//            }
//            List<List<WangdiantongOrder>> results = new ArrayList<>();
//            List<Future<List<WangdiantongOrder>>> futures = ((ThreadPoolTaskExecutor) customThreadPool).getThreadPoolExecutor().invokeAll(tasks);
//            for (Future<List<WangdiantongOrder>> future : futures) {
//                results.add(future.get());
//            }
//            log.info("多线程共处理了{}条数据", results.size());
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//        }
//    }


}
