package com.link.bi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.bi.domain.dao.CollectOrderLogInfoDao;
import com.link.bi.domain.entity.CollectOrderLogInfo;
import com.link.bi.domain.mapper.CollectOrderLogInfoMapper;
import com.link.bi.service.CollectOrderLogInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class CollectOrderLogInfoServiceImpl extends ServiceImpl<CollectOrderLogInfoMapper, CollectOrderLogInfo> implements CollectOrderLogInfoService {

    @Autowired
    private CollectOrderLogInfoDao dao;



    @Override
    public List<CollectOrderLogInfo> list(Wrapper<CollectOrderLogInfo> queryWrapper) {
        return list(queryWrapper);
    }
    /**
     * 查询最新修改日期
     * @return
     */
    @Override
    public Date selectLatest(Integer syncType) {
        // 查询最新发货日期
        Date date = dao.selectOrderLatest(syncType);
        return date;
    }


}
