package com.link.bi.pojo.response;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 财务聚合后查看的详情信息，来自订单明细DTO
 * @date : 2025-01-15 17:01:00
 * @author : lvbencai
 */
@Data
public class FinanceOrderDetailListDto {
    // 订单编号
    private String tradeNo;
    // 店铺名称
    private String shopName;
    // 原始单号
    private String srcTid;
    // 原始子单号
    private String srcOid;
    // 订单状态
    private int tradeStatus;
    // 交易时间
    private String tradeTime;
    // 付款时间
    private Date payTime;
    // 发货时间
    private Date consignTime;
    // 省市县（收货地区）
    private String receiverArea;
    // 备注
    private String remark;
    // 应收金额
    private BigDecimal receivable;
    // 货品编号
    private String goodsNo;
    // 货品名称
    private String goodsName;
    // 规格名称
    private String specName;
    // 分类（货品类型）
    private int goodsType;
    // 数量
    private BigDecimal num;
    // 优惠
    private BigDecimal discount;
    // 分摊后总价
    private BigDecimal shareAmount;
    // 组合装编码
    private String suiteNo;
    // 组合装名称
    private String suiteName;
    // 组合装数量
    private BigDecimal suiteNum;
    // 赠品方式
    private int giftType;
    // 分销商名称
    private String fenxiaoName;
    // 分销商编号
    private String fenxiaoId;
    // 平台货品名称
    private String apiGoodsName;

}
