package com.link.bi.controller.query;

import com.link.bi.pojo.request.EcStoreVo;
import com.link.bi.service.IEcStoreService;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-11-20 15
 * @describe :
 */
@RestController
@RequestMapping("/store/query")
public class EcStoreQueryController {

    @Autowired
    IEcStoreService ecStoreService;

    /**
     * 查询电商-店铺列表
     */
    @RequiresPermissions("bi:store:list")
    @GetMapping("/list")
    public PageInfo list(EcStoreVo ecStoreVo)
    {
        return ecStoreService.selectPage(ecStoreVo);
    }

    /**
     * 导出电商-店铺列表
     */
//    @RequiresPermissions("bi:store:list")
//    @Log(title = "电商-店铺", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, EcStore ecStore)
//    {
//        List<EcStore> list = ecStoreService.selectEcStoreList(ecStore);
//        ExcelUtil<EcStore> util = new ExcelUtil<EcStore>(EcStore.class);
//        util.exportExcel(response, list, "电商-店铺数据");
//    }

    /**
     * 获取电商-店铺详细信息
     */
//    @RequiresPermissions("bi:store:list")
//    @GetMapping(value = "/{storeId}")
//    public AjaxResult getInfo(@PathVariable("storeId") Long storeId)
//    {
//        return success(ecStoreService.selectEcStoreByStoreId(storeId));
//    }
}
